import { Component, OnInit, Inject } from '@angular/core'
import {
  FormControl,
  FormGroup,
  Validators
} from '@angular/forms';

import { ErrorService } from '../../core/error-messages/error.service'
import {
  FhirService,
  FhirServiceConst,
  ResourceInt
} from '../../mccf-data/fhir/fhir.service'
import { Resource } from '../../mccf-data/fhir/resource'

@Component({
  selector: 'app-fhir-resource',
  templateUrl: './fhir-resource.component.html',
  styleUrls: ['./fhir-resource.component.css'],
  providers: [FhirService]
})
export class FhirResourceComponent implements OnInit {
  isLoading = true
  fhirConst = FhirServiceConst
  page = 'select'
  idTerm = "ID"
  errorMessage = ''
  util = this.fhirConst.utilGetRecord
  type = this.fhirConst.typePrc
  service: FhirService
  resource: Resource

  // form controls
  fhirSearchGroup: FormGroup;
  fhirId: FormControl;
  fhirAccessCode: FormControl;
  fhirVerifyCode: FormControl;
  fhirAccessCodeAuthorized = true

  constructor( @Inject(FhirService) Service, private errorService: ErrorService) {
    this.service = Service;
  }

  ngOnInit() {
    this.fhirSearchGroup = new FormGroup({
      id: new FormControl('58', Validators.required),
      util: new FormControl(this.util),
      type: new FormControl(this.type)
    })
    this.isLoading = false

  }

  public fhirUtilChange(id: any) {
    let valueId = (id.srcElement || id.target).value
    this.util = valueId
    if (this.util === this.fhirConst.utilFind) {
      this.idTerm = 'Search Term'
    } else {
      this.idTerm = 'ID'
    }
  }

  public onSubmit({ value, valid }: { value: ResourceInt, valid: boolean }) {
    this.isLoading = true
    this.type = value.type
    this.util = value.util

    this.service.getResource(value)
      .then(res => {
        this.isLoading = false
        this.resource = res
        this.page = 'resource'
      })
      .catch(err => {
        this.isLoading = false
        this.page = 'notfound'
      })

  }

  public back() {
    this.page = 'select'
  }

  public getFindNotice(evnt) {

    this.isLoading = true
    this.util = this.fhirConst.utilGetRecord

    let param = { id: evnt, util: this.util, type: this.type }

    this.service.getResource(param)
      .then(res => {
        this.isLoading = false
        this.resource = res
        this.page = 'resource'
      })
      .catch(err => {
        this.isLoading = false
        this.page = 'notfound'
      })

  }

}
